import java.util.Arrays;
import java.util.Scanner;

public class ObaranjeRuku {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        // Ulazni podaci
        int N = scanner.nextInt();
        int[] P = new int[N];
        for (int i = 0; i < N; i++) {
            P[i] = scanner.nextInt();
        }

        int Q = scanner.nextInt();
        int[][] options = new int[Q][2];
        for (int i = 0; i < Q; i++) {
            options[i][0] = scanner.nextInt();
            options[i][1] = scanner.nextInt();
        }

        // Izlazni podaci
        int[] results = new int[Q];

        for (int q = 0; q < Q; q++) {
            int Mi = options[q][0];
            int Ji = options[q][1];

            int[] powerOrder = new int[N];
            for (int i = 0; i < N; i++) {
                powerOrder[i] = P[i];
            }

            int maxRounds = 0;

            for (int i = 0; i < Ji; i++) {
                // Pronalaženje najslabijeg ucesnika koji nije Mi
                int minIndex = -1;
                for (int j = 0; j < N; j++) {
                    if (powerOrder[j] < powerOrder[Mi - 1] && (minIndex == -1 || powerOrder[j] < powerOrder[minIndex])) {
                        minIndex = j;
                    }
                }

                // Zamena pozicija izmedu minIndex i Mi
                int temp = powerOrder[MinIndex];
                powerOrder[minIndex] = powerOrder[Mi - 1];
                powerOrder[Mi - 1] = temp;

                // Racunanje novog broja krugova
                int rounds = calculateRounds(powerOrder, N);
                maxRounds = Math.max(maxRounds, rounds);
            }

            results[q] = maxRounds;
        }

        // Ispisivanje rezultata
        for (int i = 0; i < Q; i++) {
            System.out.println(results[i]);
        }
    }

    // Pomocna metoda za racunanje broja krugova
    private static int calculateRounds(int[] order, int N) {
        int rounds = 0;
        int participants = N;

        while (participants > 1) {
            rounds++;
            participants /= 2;
        }

        return rounds;
    }
}